mod socks;
mod stream_copy;
mod unshare;

use unshare::CloneFlags;
// use unshare::UidGid;
use unshare::Unshare;

use passfd::FdPassingExt;
use std::net::IpAddr;
use std::net::Ipv4Addr;
use std::net::{TcpListener, TcpStream};
use std::os::unix::io::AsRawFd;
use std::os::unix::io::FromRawFd;
use std::os::unix::net::UnixStream;
use std::os::unix::process::CommandExt;

use socks::ConnectTarget;
use socks::Socks;
use stream_copy::BidirectionalStreamCopy;

fn handle_socks(mut incoming: TcpStream) -> std::io::Result<()> {
    let mut socks = Socks::new(&mut incoming);

    socks.handle_authentication()?;
    let connect_target = socks.get_connect_target()?;
    let allow_connection = match &connect_target {
        ConnectTarget::IPAddress(IpAddr::V4(ip), _port) => ip == &Ipv4Addr::new(169, 254, 169, 2),
        ConnectTarget::Domain(domain, _port) => domain == "www.digiges.ch",
        _ => false,
    };
    if !allow_connection {
        return socks.refuse_connection();
    }
    let outgoing = socks.establish_connection_to_target(connect_target)?;

    let mut copy = BidirectionalStreamCopy::new(incoming, outgoing)?;
    copy.copy_streams()
}

fn main() -> std::io::Result<()> {
    let (parent_sock, netns_sock) = UnixStream::pair().unwrap();
    // let parent_uid_gid = UidGid::from_current();

    let mut command = std::process::Command::new("bash");
    let command = unsafe {
        command.pre_exec(move || {
            let _unshare = Unshare::new(&[CloneFlags::Newuser, CloneFlags::Newnet])?;
            // unshare.map_uid_gid(parent_uid_gid)?;

            let socks_listener = TcpListener::bind((Ipv4Addr::LOCALHOST, 1080)).map_err(|e| {
                std::io::Error::new(e.kind(), format!("binding to TCP port failed: {}", e))
            })?;
            netns_sock.send_fd(socks_listener.as_raw_fd())
        })
    };
    let mut child = command.spawn().unwrap();

    let socks_listener_fd = parent_sock.recv_fd()?;
    let socks_listener = unsafe { TcpListener::from_raw_fd(socks_listener_fd) };

    std::thread::spawn(move || -> std::io::Result<()> {
        for stream in socks_listener.incoming() {
            if let Err(e) = handle_socks(stream?) {
                eprintln!("{}", e);
            }
        }
        Ok(())
    });

    match child.wait() {
        Ok(code) => std::process::exit(code.code().unwrap()),
        Err(e) => Err(e),
    }
}
