mod socks;
mod stream_copy;

use std::net::IpAddr;
use std::net::Ipv4Addr;
use std::net::TcpListener;
use std::net::TcpStream;

use socks::ConnectTarget;
use socks::Socks;
use stream_copy::BidirectionalStreamCopy;

fn handle_socks(mut incoming: TcpStream) -> std::io::Result<()> {
    let mut socks = Socks::new(&mut incoming);

    socks.handle_authentication()?;
    let connect_target = socks.get_connect_target()?;
    let allow_connection = match &connect_target {
        ConnectTarget::IPAddress(IpAddr::V4(ip), _port) => ip == &Ipv4Addr::new(169, 254, 169, 2),
        ConnectTarget::Domain(domain, _port) => domain == "www.digiges.ch",
        _ => false,
    };
    if !allow_connection {
        return socks.refuse_connection();
    }
    let outgoing = socks.establish_connection_to_target(connect_target)?;

    let mut copy = BidirectionalStreamCopy::new(incoming, outgoing)?;
    copy.copy_streams()
}

fn main() -> std::io::Result<()> {
    let socks_listener = TcpListener::bind((Ipv4Addr::new(169, 254, 24, 1), 1080))?;

    for stream in socks_listener.incoming() {
        match handle_socks(stream?) {
            Ok(()) => {}
            Err(e) => eprintln!("{}", e),
        };
    }

    Ok(())
}
