use std::io::Read;
use std::io::Write;

use std::net::Ipv4Addr;
use std::net::TcpListener;
use std::net::TcpStream;

fn main() -> std::io::Result<()> {
    let listener = TcpListener::bind((Ipv4Addr::new(169, 254, 24, 1), 8000))?;

    loop {
        let (mut incoming, peer) = listener.accept()?;
        dbg!(peer);
        let mut outgoing = TcpStream::connect((Ipv4Addr::new(169, 254, 169, 2), 8000))?;

        let mut buf = [0u8; 4096];
        loop {
            let bytes_read = incoming.read(&mut buf)?;
            if bytes_read == 0 {
                break;
            }
            outgoing.write_all(&buf[..bytes_read])?;
        }
    }
}
