#!/bin/bash

ip netns del wk24 2> /dev/null
ip netns add wk24 2> /dev/null

# Create local endpoint to test connection
ip link add wg1 type wireguard
wg setconf wg1 wg1.conf
ip address add 169.254.0.2/24 dev wg1
ip link set wg1 up

# Wireguard endpoint to move into netns
(set -x
ip link add wg0 type wireguard
wg setconf wg0 wg0.conf
ip link set wg0 netns wk24)
read
(set -x
ip netns exec wk24 ip address add 169.254.0.1/24 dev wg0
ip netns exec wk24 ip link set wg0 up
ip netns exec wk24 ip route show
)
read
(set -x
ip netns exec wk24 wg show wg0
)
read
(set -x
ip netns exec wk24 ping -c1 169.254.0.2
)

ip netns exec wk24 ip link del wg0
ip link del wg1
